<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Facelogin extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['facedata_model', 'staff_model', 'settings_model']);
    }

    /**
     * Display the list of hosting records.
     */
    public function setup()
    {
		if (get_option('facelogin_purchase_is_valid') == 1) {

			$data['title'] = _l('facelogin_setup');
			$existing = $this->facedata_model->get_by_user(get_staff_user_id(), 'staff');
			$data['is_active'] = isset($existing->is_active) ? 1:0;
			$this->load->view('setup', $data);
		}else{
			 set_alert('danger', _l('First Verify Purchase code.'));
			 redirect(admin_url('facelogin/setting'));
		}
    }

    public function save_face() {
        $data = $this->input->post();

        $user_id = $data['user_id'];
        $face_json = $data['face_json'];
        $user_type = 'staff'; // you can also accept from $data if needed

        // Check if user already has a face record
        $existing = $this->facedata_model->get_by_user($user_id, $user_type);

        if ($existing) {
            // Overwrite existing JSON file
            $json_file = FACELOGIN_JSONSAVE_FOLDER . '/'.$existing->uniq_id . '.json';
            file_put_contents($json_file, $face_json);

            echo json_encode(['status' => 'updated', 'message' => 'Face data updated.']);
        } else {
            // Create new record
            $uniq_id = time();
            $insert_data = [
                'user_id'     => $user_id,
                'user_type'   => $user_type,
                'uniq_id'     => $uniq_id,
                'is_active'   => 1,
                'created_by'  => get_staff_user_id(),
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ];

            $insert_id = $this->facedata_model->add($insert_data);
            if ($insert_id) {
                file_put_contents(FACELOGIN_JSONSAVE_FOLDER . '/'. "$uniq_id.json", $face_json);
                echo json_encode(['status' => true, 'message' => 'Face data saved.']);
            } else {
                echo json_encode(['status' => false, 'message' => 'DB insert failed.']);
            }
        }
    }

    public function verify_face()
    {
        $data = $this->input->post();

        if (!isset($data['user_json']) || !isset($data['user_id'])) {
            echo json_encode(['status' => 'failed', 'message' => 'Invalid input']);
            return;
        }

        $user_id = $data['user_id'];
        $incomingDescriptor = json_decode($data['user_json']);

        // Load existing face data for the user
        $this->load->model('facedata_model');
        $record = $this->facedata_model->get_by_user_id($user_id);

        if (!$record) {
            echo json_encode(['status' => 'failed', 'message' => 'No face data found for this user']);
            return;
        }

        $json_file = FACELOGIN_JSONSAVE_FOLDER . $record->uniq_id . ".json";

        if (!file_exists($json_file)) {
            echo json_encode(['status' => 'failed', 'message' => 'Face data file missing']);
            return;
        }

        $storedDescriptor = json_decode(file_get_contents($json_file));

        // Compare using Euclidean distance
        $distance = $this->calculateEuclideanDistance($incomingDescriptor, $storedDescriptor);
        $threshold = 0.5; // adjust based on testing

        if ($distance < $threshold) {
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'failed', 'message' => 'Face not matched']);
        }
    }
    private function calculateEuclideanDistance($a, $b)
    {
        $sum = 0.0;
        for ($i = 0; $i < count($a); $i++) {
            $sum += pow($a[$i] - $b[$i], 2);
        }
        return sqrt($sum);
    }

    function remove_face() {
        $user_id = get_staff_user_id();
        $user_type = 'staff';

        // Get existing face data
        $existing = $this->facedata_model->get_by_user($user_id, $user_type);

        if ($existing) {
            $json_file = FACELOGIN_JSONSAVE_FOLDER . '/' . $existing->uniq_id . '.json';

            // Delete JSON file if it exists
            if (file_exists($json_file)) {
                unlink($json_file);
            }

            // Remove DB record
            $this->db->where('id', $existing->id);
            $this->db->delete(db_prefix() . 'face_data');
            set_alert('success', _l('Face data removed'));
        } else {
            set_alert('danger', _l('No face data found.'));
        }
        redirect(admin_url('facelogin/setup'));

    }

    /**
     * Manage Domain Manager settings.
     *
     * @return void
     */
    public function setting()
    {
        if ($this->input->post()) {
            $post_data = $this->input->post();
            $purchase_code = $post_data['settings']['facelogin_purchase_code'];


                $post_data['settings']['facelogin_purchase_is_valid'] = 1;
                $success = $this->settings_model->update($post_data);

                set_alert($success ? 'success' : 'danger', $success ? _l('Settings updated') : _l('An error occurred while updating settings'));
            

            redirect(admin_url('facelogin/setting'));
        }

        $data['title'] = _l('FaceLogin Settings');
        $this->load->view('manage', $data);
    }



}
